/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class RcsControl {
    private static final String TRACE_MASKT = "XRCSCTRT";
    private static final String TRACE_MASKF = "XRCSCTRF";
    private static final String TRACE_MASKD = "XRCSCTRD";
    private static final String PROG_MODEM = "rcsModemSecure.pl";
    private static final String PROG_NAME = "rcsControl.pl";
    public static final int MODEM_NONE = 0;
    public static final int MODEM_GENERIC = 1;
    public static final int MODEM_MULTITECH_INT_56K = 2;
    public static final int MODEM_MULTITECH_EXT_56K = 3;
    public static final int MODEM_MULTITECH_EXT_33K = 4;
    public static final int MODEM_MICROCOM_DESKPORTE = 5;
    public static int modemType = 0;
    private static Object lock = new Object();
    public static String configPath;

    private RcsControl() {
    }

    public static int startDial() {
        return RcsControl.execute("--startdial");
    }

    public static int stopDial() {
        return RcsControl.execute("--stopdial");
    }

    public static int startVpn() {
        return RcsControl.execute("--startvpn");
    }

    public static int stopVpn() {
        return RcsControl.execute("--stopvpn");
    }

    public static int startServiceVpn() {
        return RcsControl.execute("--startservicevpn");
    }

    public static int stopServiceVpn() {
        return RcsControl.execute("--stopservicevpn");
    }

    public static int startServiceDial() {
        return RcsControl.execute("--startservicedial");
    }

    public static int stopServiceDial() {
        return RcsControl.execute("--stopservicedial");
    }

    public static int startRemDial() {
        return RcsControl.execute("--startremdial");
    }

    public static int stopRemDial() {
        return RcsControl.execute("--stopremdial");
    }

    public static int startRemVpn() {
        return RcsControl.execute("--startremvpn");
    }

    public static int stopRemVpn() {
        return RcsControl.execute("--stopremvpn");
    }

    public static int forceUpdate() {
        return RcsControl.execute("--updateconfig");
    }

    public static int runModemAnswer() {
        return RcsControl.execute("--runmodemanswer");
    }

    public static int stopModemAnswer() {
        return RcsControl.execute("--stopmodemanswer");
    }

    public static int serviceStatus() {
        return RcsControl.execute("--servicestatus");
    }

    public static int quit() {
        return RcsControl.execute("--quit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int init() {
        Trace.trace(TRACE_MASKT, "--> init()");
        int rc = 0;
        Object object = lock;
        synchronized (object) {
            try {
                RcsConfig rcsConfig = RcsConfig.getRcsConfig();
                rcsConfig.storeConfig();
                rc = RootProcess.executeProgram("rcsControl.pl --data " + configPath);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- init() [" + rc + "]");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int execute(String parms) {
        Trace.trace(TRACE_MASKT, "--> execute( " + parms + " )");
        String command = "rcsControl.pl " + parms;
        int rc = 0;
        Object object = lock;
        synchronized (object) {
            try {
                rc = RootProcess.executeProgram("rcsControl.pl --checkdaemon");
                if (rc != 0) {
                    RcsControl.init();
                }
                RcsConfig rcsConfig = RcsConfig.getRcsConfig();
                rcsConfig.storeConfig();
                rc = RootProcess.executeProgram("rcsControl.pl " + parms);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- execute() [" + rc + "]");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryModem() {
        Trace.trace(TRACE_MASKT, "--> queryModem()");
        String command = "rcsModemSecure.pl --setup";
        int rc = 0;
        Object object = lock;
        synchronized (object) {
            try {
                rc = RootProcess.executeProgram(command);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        if (rc < 10) {
            modemType = rc;
        }
        Trace.trace(TRACE_MASKT, "<-- queryModem() [" + rc + "]");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resetModem() {
        Trace.trace(TRACE_MASKT, "--> queryModem()");
        String modemPostInit = ModemConfigManager.getModemConfigManager().getModemConfig().getPostInitString();
        String command = "rcsModemSecure.pl --setup --reset " + modemPostInit;
        int rc = 0;
        Object object = lock;
        synchronized (object) {
            try {
                rc = RootProcess.executeProgram(command);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        if (rc < 10) {
            modemType = rc;
        }
        Trace.trace(TRACE_MASKT, "<-- queryModem() [" + rc + "]");
        return rc;
    }

    public static void queryModemBackground() {
        Trace.trace(TRACE_MASKT, "<-> queryModem()");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    String command = "rcsModemSecure.pl --setup";
                    int rc = 0;
                    try {
                        rc = RootProcess.executeProgram(command);
                    }
                    catch (IOException e) {
                        Trace.trace(RcsControl.TRACE_MASKF, "Exception: " + e);
                    }
                    if (rc < 10) {
                        modemType = rc;
                    }
                    Trace.trace(RcsControl.TRACE_MASKF, "Modem Type: " + rc);
                }
            }
        }.start();
    }

    public static int getModemType() {
        return modemType;
    }

    static {
        try {
            configPath = BaseFileControl.getFilePath("rcsconfig");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
            configPath = "/opt/ccfw/data/rcs";
        }
        RcsControl.queryModemBackground();
    }
}

